/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ClientProxy;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.PotionBase;
import com.lycanitesmobs.Utilities;
import com.lycanitesmobs.core.block.BlockSlabCustom;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.info.EntityListCustom;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.item.ItemBase;
import com.lycanitesmobs.core.item.ItemSlabCustom;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ObjectManager {
    public static Map<String, Block> blocks = new HashMap<String, Block>();
    public static Map<String, Item> items = new HashMap<String, Item>();
    public static Map<String, Fluid> fluids = new HashMap<String, Fluid>();
    public static Map<Block, Item> buckets = new HashMap<Block, Item>();
    public static Map<String, Class> tileEntities = new HashMap<String, Class>();
    public static Map<String, PotionBase> potionEffects = new HashMap<String, PotionBase>();
    public static int nextPotionID = 28;
    public static Map<String, EntityListCustom> entityLists = new HashMap<String, EntityListCustom>();
    public static Map<String, MobInfo> mobs = new HashMap<String, MobInfo>();
    public static Map<String, Class> projectiles = new HashMap<String, Class>();
    public static Map<String, DamageSource> damageSources = new HashMap<String, DamageSource>();
    public static Map<String, Achievement> achievements = new HashMap<String, Achievement>();
    public static GroupInfo currentGroup;

    public static void setCurrentGroup(GroupInfo group) {
        currentGroup = group;
    }

    public static Block addBlock(String name, Block block) {
        name = name.toLowerCase();
        blocks.put(name, block);
        GameRegistry.register((IForgeRegistryEntry)block);
        if (block instanceof BlockSlabCustom) {
            BlockSlabCustom blockSlab = (BlockSlabCustom)block;
            GameRegistry.register((IForgeRegistryEntry)new ItemSlabCustom((Block)blockSlab, blockSlab, blockSlab.getDoubleBlock()), (ResourceLocation)block.getRegistryName());
        } else {
            GameRegistry.register((IForgeRegistryEntry)new ItemBlock(block), (ResourceLocation)block.getRegistryName());
        }
        LycanitesMobs.proxy.addBlockRender(currentGroup, block);
        return block;
    }

    public static Fluid addFluid(String fluidName) {
        GroupInfo group = currentGroup;
        Fluid fluid = new Fluid(fluidName, new ResourceLocation(group.filename + ":blocks/" + fluidName + "_still"), new ResourceLocation(group.filename + ":blocks/" + fluidName + "_flow"));
        String name = fluid.getUnlocalizedName().toLowerCase();
        fluids.put(name, fluid);
        FluidRegistry.registerFluid((Fluid)fluid);
        return fluid;
    }

    public static Item addBucket(Item bucket, Block block, Fluid fluid) {
        buckets.put(block, bucket);
        return bucket;
    }

    public static Item addItem(String name, Item item) {
        name = name.toLowerCase();
        items.put(name, item);
        if (currentGroup != null) {
            GameRegistry.register((IForgeRegistryEntry)item, (ResourceLocation)new ResourceLocation(ObjectManager.currentGroup.filename, name));
        }
        LycanitesMobs.proxy.addItemRender(currentGroup, item);
        if (item instanceof ItemBucket) {
            BehaviorDefaultDispenseItem ibehaviordispenseitem = new BehaviorDefaultDispenseItem(){
                private final BehaviorDefaultDispenseItem dispenseBehavior = new BehaviorDefaultDispenseItem();

                public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                    ItemBucket itembucket = (ItemBucket)stack.func_77973_b();
                    BlockPos blockpos = source.func_180699_d().func_177972_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
                    return itembucket.func_180616_a(null, source.func_82618_k(), blockpos) ? new ItemStack(Items.field_151133_ar) : this.dispenseBehavior.func_82482_a(source, stack);
                }
            };
            BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)ibehaviordispenseitem);
        }
        return item;
    }

    public static Item addItem(String name, Item item, int weight, int minAmount, int maxAmount) {
        Utilities.addDungeonLoot(new ItemStack(item), minAmount, maxAmount, weight);
        Utilities.addStrongholdLoot(new ItemStack(item), minAmount, maxAmount, weight * 2);
        Utilities.addVillageLoot(new ItemStack(item), minAmount, maxAmount, weight);
        return ObjectManager.addItem(name, item);
    }

    public static Class addTileEntity(String name, Class tileEntityClass) {
        name = name.toLowerCase();
        tileEntities.put(name, tileEntityClass);
        GameRegistry.registerTileEntity((Class)tileEntityClass, (String)("lycanitesmobs." + name));
        return tileEntityClass;
    }

    public static PotionBase addPotionEffect(String name, ConfigBase config, boolean isBad, int color, int iconX, int iconY, boolean goodEffect) {
        PotionBase potion = new PotionBase("potion." + name, isBad, color);
        potion.func_76399_b(iconX, iconY);
        potionEffects.put(name, potion);
        GameRegistry.register((IForgeRegistryEntry)potion, (ResourceLocation)new ResourceLocation("lycanitesmobs", name));
        ObjectLists.addEffect(goodEffect ? "buffs" : "debuffs", potion);
        return potion;
    }

    public static MobInfo addMob(MobInfo mobInfo) {
        GroupInfo group = mobInfo.group;
        String name = mobInfo.name.toLowerCase();
        mobs.put(name, mobInfo);
        AssetManager.addSound(name + "_say", group, "entity." + name + ".say");
        AssetManager.addSound(name + "_hurt", group, "entity." + name + ".hurt");
        AssetManager.addSound(name + "_death", group, "entity." + name + ".death");
        AssetManager.addSound(name + "_step", group, "entity." + name + ".step");
        AssetManager.addSound(name + "_attack", group, "entity." + name + ".attack");
        AssetManager.addSound(name + "_jump", group, "entity." + name + ".jump");
        AssetManager.addSound(name + "_fly", group, "entity." + name + ".fly");
        if (mobInfo.isSummonable() || mobInfo.isTameable()) {
            AssetManager.addSound(name + "_tame", group, "entity." + name + ".tame");
        }
        if (mobInfo.isSummonable() || mobInfo.isTameable()) {
            AssetManager.addSound(name + "_beg", group, "entity." + name + ".beg");
        }
        if (mobInfo.isTameable()) {
            AssetManager.addSound(name + "_eat", group, "entity." + name + ".eat");
        }
        if (EntityCreatureRideable.class.isAssignableFrom(mobInfo.entityClass) && (mobInfo.isSummonable() || mobInfo.isTameable())) {
            AssetManager.addSound(name + "_mount", group, "entity." + name + ".mount");
        }
        if (mobInfo.isBoss()) {
            AssetManager.addSound(name + "_phase", group, "entity." + name + ".phase");
        }
        return mobInfo;
    }

    public static void addProjectile(String name, Class entityClass, int updateFrequency) {
        name = name.toLowerCase();
        GroupInfo group = currentGroup;
        AssetManager.addSound(name, group, "projectile." + name);
        int projectileID = group.getNextProjectileID();
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(group.filename, name), (Class)entityClass, (String)name, (int)projectileID, (Object)group.mod, (int)64, (int)updateFrequency, (boolean)true);
        projectiles.put(name, entityClass);
        group.projectileClasses.add(entityClass);
    }

    public static void addProjectile(String name, Class entityClass) {
        ObjectManager.addProjectile(name, entityClass, 1);
    }

    public static void addProjectile(String name, Class entityClass, Item item, BehaviorProjectileDispense dispenseBehaviour) {
        name = name.toLowerCase();
        ObjectManager.addProjectile(name, entityClass);
        BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)dispenseBehaviour);
    }

    public static void addDamageSource(String name, DamageSource damageSource) {
        name = name.toLowerCase();
        damageSources.put(name, damageSource);
    }

    public static void addAchievement(String name, Achievement achievement) {
        if (achievements.containsKey(name = name.toLowerCase())) {
            return;
        }
        achievement.func_75971_g();
        achievements.put(name, achievement);
    }

    public static Block getBlock(String name) {
        if (!blocks.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return blocks.get(name);
    }

    public static Item getItem(String name) {
        if (!items.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return items.get(name);
    }

    public static Class getTileEntity(String name) {
        if (!tileEntities.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return tileEntities.get(name);
    }

    public static PotionBase getPotionEffect(String name) {
        if (!potionEffects.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return potionEffects.get(name);
    }

    public static Class getMob(String mobName) {
        if (!mobs.containsKey(mobName = mobName.toLowerCase())) {
            return null;
        }
        return ObjectManager.mobs.get((Object)mobName).entityClass;
    }

    public static MobInfo getMobInfo(String mobName) {
        if (!mobs.containsKey(mobName = mobName.toLowerCase())) {
            return null;
        }
        return mobs.get(mobName);
    }

    public static DamageSource getDamageSource(String name) {
        if (!damageSources.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return damageSources.get(name);
    }

    public static Achievement getAchievement(String name) {
        if (!achievements.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return achievements.get(name);
    }

    @SideOnly(value=Side.CLIENT)
    public static void RegisterModels() {
        for (Item item : items.values()) {
            ItemBase itemBase;
            if (!(item instanceof ItemBase) || !(itemBase = (ItemBase)item).useItemColors()) continue;
            Minecraft.func_71410_x().getItemColors().func_186730_a(ClientProxy.itemColor, new Item[]{item});
        }
    }
}

